<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Distributor;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class DistributorController extends Controller
{
    public function index()
    {
        $distributors = Distributor::with('imageFile')->latest()->paginate(10);
        return view('admin.distributors.index', compact('distributors'));
    }

    public function create()
    {
        return view('admin.distributors.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|string'
        ]);

        Distributor::create([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'image' => $request->image
        ]);

        return redirect()->route('admin.distributors.index')->with('success', 'Distributor added successfully.');
    }

    public function edit(Distributor $distributor)
    {
        return view('admin.distributors.edit', compact('distributor'));
    }

    public function update(Request $request, Distributor $distributor)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|string'
        ]);

        $distributor->update([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'image' => $request->image
        ]);

        return redirect()->route('admin.distributors.index')->with('success', 'Distributor updated successfully.');
    }

    public function destroy(Distributor $distributor)
    {
        $distributor->delete();
        return back()->with('success', 'Distributor deleted successfully.');
    }
}
