<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Image;
use App\Models\Folder;
use Illuminate\Http\Request;

class ImageModalController extends Controller
{
    public function getFolders()
    {
        return response()->json(Folder::withCount('images')->get());
    }

    public function getImages($folderId = null)
    {
        $query = Image::query();
        if ($folderId) {
            $query->where('folder_id', $folderId);
        }
        return response()->json($query->latest()->get());
    }
}
