<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NavbarLink;
use Illuminate\Http\Request;

class NavbarLinkController extends Controller
{
    public function index()
    {
        $links = NavbarLink::orderBy('order')->get();
        return view('admin.navbar_links.index', compact('links'));
    }

    public function create()
    {
        return view('admin.navbar_links.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'url' => 'required|string|max:255',
            'order' => 'nullable|integer',
            'status' => 'boolean',
        ]);

        NavbarLink::create($request->all());

        return redirect()->route('admin.navbar-links.index')->with('success', 'Navbar link created successfully.');
    }

    public function edit(NavbarLink $navbarLink)
    {
        return view('admin.navbar_links.edit', compact('navbarLink'));
    }

    public function update(Request $request, NavbarLink $navbarLink)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'url' => 'required|string|max:255',
            'order' => 'nullable|integer',
            'status' => 'boolean',
        ]);

        $navbarLink->update($request->all());

        return redirect()->route('admin.navbar-links.index')->with('success', 'Navbar link updated successfully.');
    }

    public function destroy(NavbarLink $navbarLink)
    {
        $navbarLink->delete();
        return redirect()->route('admin.navbar-links.index')->with('success', 'Navbar link deleted successfully.');
    }
}
