<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PageSeo;
use Illuminate\Http\Request;

class PageSeoController extends Controller
{
    public function index()
    {
        $seos = PageSeo::latest()->get();
        return view('admin.page-seos.index', compact('seos'));
    }

    public function create()
    {
        return view('admin.page-seos.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'page_name' => 'required|string|unique:page_seos,page_name',
            'meta_title' => 'nullable|string|max:255',
            'meta_keywords' => 'nullable|string',
            'meta_description' => 'nullable|string',
        ]);

        PageSeo::create($request->all());

        return redirect()->route('admin.page-seos.index')->with('success', 'Page SEO created successfully.');
    }

    public function edit(PageSeo $page_seo)
    {
        return view('admin.page-seos.edit', compact('page_seo'));
    }

    public function update(Request $request, PageSeo $page_seo)
    {
        $request->validate([
            'page_name' => 'required|string|unique:page_seos,page_name,' . $page_seo->id,
            'meta_title' => 'nullable|string|max:255',
            'meta_keywords' => 'nullable|string',
            'meta_description' => 'nullable|string',
        ]);

        $page_seo->update($request->all());

        return redirect()->route('admin.page-seos.index')->with('success', 'Page SEO updated successfully.');
    }

    public function destroy(PageSeo $page_seo)
    {
        $page_seo->delete();
        return back()->with('success', 'Page SEO deleted successfully.');
    }
}
