<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SocialMedia;
use Illuminate\Http\Request;

class SocialMediaController extends Controller
{
    public function index()
    {
        $socials = SocialMedia::latest()->get();
        return view('admin.social-media.index', compact('socials'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'url' => 'required|url',
            'icon' => 'nullable|string'
        ]);

        SocialMedia::create($request->all());

        return back()->with('success', 'Social media link added successfully.');
    }

    public function update(Request $request, SocialMedia $social_media)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'url' => 'required|url',
            'icon' => 'nullable|string'
        ]);

        $social_media->update($request->all());

        return back()->with('success', 'Social media link updated successfully.');
    }

    public function destroy(SocialMedia $social_media)
    {
        $social_media->delete();
        return back()->with('success', 'Social media link deleted successfully.');
    }
}
