<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Image;
use App\Models\Setting;
use Illuminate\Http\Request;

class HomeCmsController extends Controller
{
    public function getHome()
    {
        $hero = Setting::where('key', 'home_hero')->first();
        $banner = Setting::where('key', 'home_banner')->first();

        $homeHero = $hero ? json_decode($hero->value) : null;
        $homeBanner = $banner ? json_decode($banner->value) : null;

        if ($homeHero && isset($homeHero->bg_image) && is_numeric($homeHero->bg_image)) {
            $image = Image::find($homeHero->bg_image);
            $homeHero->bg_image = $image ? $image->path : $homeHero->bg_image;
        }

        if ($homeBanner && isset($homeBanner->bg_image) && is_numeric($homeBanner->bg_image)) {
            $image = Image::find($homeBanner->bg_image);
            $homeBanner->bg_image = $image ? $image->path : $homeBanner->bg_image;
        }

        return response()->json([
            'home_hero' => $homeHero,
            'home_banner' => $homeBanner,
        ]);
    }
}
