<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\NavbarLink;
use App\Models\Setting;
use App\Models\Service;
use App\Models\ServiceArea;
use App\Models\Pest;
use Illuminate\Http\Request;

class NavbarController extends Controller
{
    public function index()
    {
        $settings = Setting::all()->pluck('value', 'key');

        $links = NavbarLink::where('status', true)->orderBy('order')->get();

        // Get pest services (assuming services or pests are needed)
        // I will return both or filter services if there's a specific "Pest" category
        // For now, I'll return all services and all service areas as requested
        $services = Service::select('id', 'title', 'slug')->get();
        $areas = ServiceArea::select('id', 'name', 'slug')->get();
        $pests = Pest::select('id', 'title', 'slug')->get();

        return response()->json([
            'logo' => isset($settings['navbar_logo']) ? asset($settings['navbar_logo']) : null,
            'button_text' => $settings['navbar_button_text'] ?? 'Contact Us',
            'links' => $links,
            'pest_services' => $services, // Mapping to user request "pest services"
            'pests' => $pests,
            'areas' => $areas,
        ]);
    }
}
