<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function aboutUs()
    {
        $hero = Setting::where('key', 'about_hero')->first();
        $main = Setting::where('key', 'about_main')->first();
        
        return response()->json([
            'hero' => $hero ? json_decode($hero->value) : null,
            'main' => $main ? json_decode($main->value) : null,
        ]);
    }

    public function footer()
    {
        $footer = Setting::where('key', 'footer')->first();
        $social = \App\Models\SocialMedia::all();
        
        return response()->json([
            'info' => $footer ? json_decode($footer->value) : null,
            'social_links' => $social,
        ]);
    }
}
