<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $fillable = [
        'title',
        'slug',
        'short_description',
        'description',
        'image_id',
        'author_name',
        'author_image_id',
        'status',
    ];

    public function image()
    {
        return $this->belongsTo(Image::class, 'image_id');
    }

    public function authorImage()
    {
        return $this->belongsTo(Image::class, 'author_image_id');
    }
}
