<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Registration extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'image',
    ];

    public function imageFile()
    {
        return $this->belongsTo(Image::class, 'image');
    }

    public function toArray()
    {
        $attributes = parent::toArray();
        $attributes['image'] = $this->imageFile ? $this->imageFile->path : null;
        return $attributes;
    }
}
