<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    protected $fillable = [
        'category_id',
        'title',
        'slug',
        'image',
        'short_description',
        'description',
        'meta_title',
        'meta_keywords',
        'meta_description'
    ];

    public function category()
    {
        return $this->belongsTo(ServiceCategory::class, 'category_id');
    }

    public function imageFile()
    {
        return $this->belongsTo(Image::class, 'image');
    }

    public function toArray()
    {
        $attributes = parent::toArray();
        $attributes['image'] = $this->imageFile ? $this->imageFile->path : null;
        return $attributes;
    }
}
