<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceCategory extends Model
{
    protected $fillable = [
        'name', 'slug', 'icon', 'is_top', 'description', 
        'meta_title', 'meta_keywords', 'meta_description', 'image_id'
    ];

    public function services()
    {
        return $this->hasMany(Service::class, 'category_id');
    }

    public function detail()
    {
        return $this->hasOne(ServiceCategoryDetail::class);
    }

    public function image()
    {
        return $this->belongsTo(Image::class);
    }
}
