<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceCategoryDetail extends Model
{
    protected $guarded = [];

    public function category()
    {
        return $this->belongsTo(ServiceCategory::class, 'service_category_id');
    }

    public function items()
    {
        return $this->hasMany(ServiceCategoryItem::class)->orderBy('sort_order');
    }

    // Image relationships for easy loading
    public function heroImage() { return $this->belongsTo(Image::class, 'hero_image_id'); }
    public function section1Image1() { return $this->belongsTo(Image::class, 'section1_image1_id'); }
    public function section1Image2() { return $this->belongsTo(Image::class, 'section1_image2_id'); }
    public function section1Image3() { return $this->belongsTo(Image::class, 'section1_image3_id'); }
    public function section2Image() { return $this->belongsTo(Image::class, 'section2_image_id'); }
}
