@extends('layouts.admin')

@section('title', 'Admin Dashboard')
@section('page_title', 'Dashboard Overview')

@section('content')
<div class="welcome-section" style="margin-bottom: 2rem; background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); padding: 2.25rem 2.5rem; border-radius: 16px; color: white; position: relative; overflow: hidden; box-shadow: 0 10px 40px rgba(15,23,42,0.2); border: 1px solid rgba(255,255,255,0.06);">
    <div style="position: relative; z-index: 1;">
        <h1 style="font-size: 1.75rem; font-weight: 700; margin-bottom: 0.4rem; font-family: 'Open Sans', sans-serif;">Welcome back, {{ Auth::user()->name }}!</h1>
        <p style="opacity: 0.85; font-size: 1rem; font-family: 'Open Sans', sans-serif;">Manage your business operations with precision and style.</p>
    </div>
    <i class="fas fa-chart-line" style="position: absolute; right: 2rem; bottom: 1.5rem; font-size: 5rem; opacity: 0.08;"></i>
</div>

<!-- Stat Cards -->
<div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(260px, 1fr)); gap: 1.5rem; margin-bottom: 3rem;">
    <!-- Products -->
    <div class="stat-card-premium">
        <div class="stat-icon" style="background: rgba(59, 130, 246, 0.1); color: #3b82f6;">
            <i class="fas fa-shopping-bag"></i>
        </div>
        <div class="stat-info">
            <h3>Total Products</h3>
            <p>{{ $stats['products'] }}</p>
        </div>
    </div>

    <!-- Services -->
    <div class="stat-card-premium">
        <div class="stat-icon" style="background: rgba(16, 185, 129, 0.1); color: #10b981;">
            <i class="fas fa-hand-holding-heart"></i>
        </div>
        <div class="stat-info">
            <h3>Total Services</h3>
            <p>{{ $stats['services'] }}</p>
        </div>
    </div>

    <!-- Orders -->
    <div class="stat-card-premium">
        <div class="stat-icon" style="background: rgba(245, 158, 11, 0.1); color: #f59e0b;">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-info">
            <h3>Total Orders</h3>
            <p>{{ $stats['orders'] }}</p>
        </div>
    </div>

    <!-- Blogs -->
    <div class="stat-card-premium">
        <div class="stat-icon" style="background: rgba(139, 92, 246, 0.1); color: #8b5cf6;">
            <i class="fas fa-blog"></i>
        </div>
        <div class="stat-info">
            <h3>Blog Posts</h3>
            <p>{{ $stats['blogs'] }}</p>
        </div>
    </div>

    <!-- Images -->
    <div class="stat-card-premium">
        <div class="stat-icon" style="background: rgba(236, 72, 153, 0.1); color: #ec4899;">
            <i class="fas fa-photo-video"></i>
        </div>
        <div class="stat-info">
            <h3>Total Images</h3>
            <p>{{ $stats['images'] }}</p>
        </div>
    </div>
</div>

<!-- Recent Orders Section -->
<div class="card">
    <div class="card-header" style="border: none; padding-bottom: 0;">
        <h2><i class="fas fa-history" style="margin-right: 10px; color: var(--primary);"></i> Recent Orders</h2>
        <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary btn-sm">View All</a>
    </div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Order ID</th>
                    <th>Customer</th>
                    <th>Date</th>
                    <th>Total Amout</th>
                    <th>Status</th>
                    <th style="text-align: right;">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($recentOrders as $order)
                <tr>
                    <td style="font-weight: 600;">#{{ $order->id }}</td>
                    <td>
                        <div style="display: flex; flex-direction: column;">
                            <span style="font-weight: 600;">{{ $order->customer_name }}</span>
                            <span style="font-size: 0.8rem; color: #64748b;">{{ $order->email }}</span>
                        </div>
                    </td>
                    <td style="color: #64748b;">{{ $order->created_at->format('M d, Y') }}</td>
                    <td style="font-weight: 700; color: #1e1e2d;">PKR {{ number_format($order->total_amount, 2) }}</td>
                    <td>
                        <span class="badge {{ $order->status == 'completed' ? 'badge-success' : ($order->status == 'cancelled' ? 'badge-danger' : 'badge-info') }}">
                            {{ strtoupper($order->status) }}
                        </span>
                    </td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.orders.show', $order) }}" class="action-btn btn-edit">
                                <i class="fas fa-eye"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" style="text-align: center; padding: 4rem; color: #94a3b8;">
                        <i class="fas fa-inbox fa-3x" style="display: block; margin-bottom: 1rem; opacity: 0.2;"></i>
                        No recent orders found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

@section('styles')
<style>
    .stat-card-premium {
        background: var(--surface);
        padding: 1.5rem 1.75rem;
        border-radius: var(--radius-lg);
        display: flex;
        align-items: center;
        gap: 1.25rem;
        box-shadow: var(--shadow);
        border: 1px solid var(--border);
        transition: all 0.25s ease;
    }
    .stat-card-premium:hover {
        transform: translateY(-3px);
        box-shadow: var(--shadow-lg);
        border-color: var(--primary);
    }
    .stat-icon {
        width: 52px;
        height: 52px;
        border-radius: var(--radius);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.35rem;
    }
    .stat-info h3 {
        color: var(--text-muted);
        font-size: 0.8rem;
        margin-bottom: 0.25rem;
        text-transform: uppercase;
        letter-spacing: 0.04em;
        font-weight: 600;
        font-family: 'Open Sans', sans-serif;
    }
    .stat-info p {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--text);
        line-height: 1;
        font-family: 'Open Sans', sans-serif;
    }
</style>
@endsection