@extends('layouts.admin')

@section('title', 'Edit FAQ')
@section('page_title', 'Update FAQ')

@section('content')
<div class="card" style="max-width: 700px; margin: 0 auto;">
    <div class="card-header">
        <h2>Edit FAQ</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.faqs.update', $faq) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label>Question <span style="color: red;">*</span></label>
                <textarea name="question" class="form-control" rows="3" required>{{ $faq->question }}</textarea>
            </div>
            <div class="form-group">
                <label>Answer <span style="color: red;">*</span></label>
                <textarea name="answer" class="form-control" rows="6" required>{{ $faq->answer }}</textarea>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.faqs.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    UPDATE FAQ
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
