@extends('layouts.admin')

@section('title', 'Manage Orders')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Orders</h2>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Order #</th>
                    <th>Customer</th>
                    <th>Total</th>
                    <th>Status</th>
                    <th>Payment</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($orders as $order)
                <tr>
                    <td style="font-weight: 700;">{{ $order->order_number }}</td>
                    <td>
                        <div>{{ $order->customer_name }}</div>
                        <small style="color: #666;">{{ $order->customer_email }}</small>
                    </td>
                    <td style="font-weight: 600;">PKR {{ number_format($order->final_amount, 2) }}</td>
                    <td>
                        <span class="badge badge-{{ $order->status == 'delivered' ? 'success' : ($order->status == 'cancelled' ? 'danger' : 'warning') }}">
                            {{ ucfirst($order->status) }}
                        </span>
                    </td>
                    <td>
                        <div style="font-size: 0.85rem; font-weight: 600;">{{ strtoupper($order->payment_method) }}</div>
                        <small class="badge {{ $order->payment_status == 'paid' ? 'badge-success' : 'badge-warning' }}" style="font-size: 0.7rem;">
                            {{ ucfirst($order->payment_status) }}
                        </small>
                    </td>
                    <td>{{ $order->created_at->format('M d, Y') }}</td>
                    <td>
                        <a href="{{ route('admin.orders.show', $order->id) }}" class="action-btn btn-edit" title="View Details">
                            <i class="fas fa-eye"></i>
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" style="padding: 2rem; text-align: center; color: #666;">No orders found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $orders->links() }}
    </div>
</div>
@endsection