@extends('layouts.admin')

@section('title', 'Order Details')

@section('content')
<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <h2 style="font-size: 1.5rem; color: #1a202c;">Order {{ $order->order_number }}</h2>
    <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary">Back to Orders</a>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
    <div style="display: flex; flex-direction: column; gap: 2rem;">
        <!-- Order Items -->
        <div class="card" style="padding: 1.5rem;">
            <h3 style="font-size: 1.1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">Ordered Items</h3>
            <div class="table-responsive">
                <table style="width: 100%;">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th style="text-align: right;">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($order->items as $item)
                        <tr>
                            <td>
                                <div style="display: flex; align-items: center; gap: 10px;">
                                    @if($item->product->thumbnail)
                                    <img src="/{{ $item->product->thumbnail->path }}" style="width: 40px; height: 40px; object-fit: cover; border-radius: 4px;">
                                    @endif
                                    <span>{{ $item->product->title }}</span>
                                </div>
                            </td>
                            <td>PKR {{ number_format($item->price, 2) }}</td>
                            <td>{{ $item->quantity }}</td>
                            <td style="text-align: right; font-weight: 600;">PKR {{ number_format($item->price * $item->quantity, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="3" style="text-align: right; padding: 1rem; font-weight: bold;">Grand Total</td>
                            <td style="text-align: right; padding: 1rem; font-weight: bold; font-size: 1.1rem; color: #2d3748;">
                                PKR {{ number_format($order->final_amount, 2) }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Customer & Shipping -->
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
            <div class="card" style="padding: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 1rem; color: #4a5568;">Customer Information</h3>
                <p><strong>Name:</strong> {{ $order->customer_name }}</p>
                <p><strong>Email:</strong> {{ $order->customer_email }}</p>
                <p><strong>Phone:</strong> {{ $order->customer_phone }}</p>
            </div>
            <div class="card" style="padding: 1.5rem;">
                <h3 style="font-size: 1rem; margin-bottom: 1rem; color: #4a5568;">Shipping Details</h3>
                <p><strong>Address:</strong><br>{{ $order->shipping_address }}</p>
                @if($order->notes)
                <p><strong>Notes:</strong><br>{{ $order->notes }}</p>
                @endif
            </div>
        </div>
    </div>

    <!-- Order Status Update -->
    <div style="display: flex; flex-direction: column; gap: 2rem;">
        <div class="card" style="padding: 1.5rem;">
            <h3 style="font-size: 1.1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #edf2f7; padding-bottom: 0.5rem;">Manage Order</h3>
            <form action="{{ route('admin.orders.status', $order->id) }}" method="POST">
                @csrf @method('PUT')

                <div class="form-group" style="margin-bottom: 1.5rem;">
                    <label style="font-weight: 600; display: block; margin-bottom: 0.5rem;">Order Status</label>
                    <select name="status" style="width: 100%;" class="form-control">
                        <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>Processing</option>
                        <option value="shipped" {{ $order->status == 'shipped' ? 'selected' : '' }}>Shipped</option>
                        <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Delivered</option>
                        <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1.5rem;">
                    <label style="font-weight: 600; display: block; margin-bottom: 0.5rem;">Payment Status</label>
                    <select name="payment_status" style="width: 100%;" class="form-control">
                        <option value="pending" {{ $order->payment_status == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="paid" {{ $order->payment_status == 'paid' ? 'selected' : '' }}>Paid</option>
                        <option value="failed" {{ $order->payment_status == 'failed' ? 'selected' : '' }}>Failed</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom: 1.5rem;">
                    <label style="font-weight: 600; display: block; margin-bottom: 0.5rem;">Tracking ID</label>
                    <input type="text" name="tracking_id" value="{{ $order->tracking_id }}" style="width: 100%;" placeholder="Enter tracking number">
                </div>

                <div class="form-group" style="margin-bottom: 1.5rem;">
                    <label style="font-weight: 600; display: block; margin-bottom: 0.5rem;">Tracking Link</label>
                    <input type="url" name="tracking_link" value="{{ $order->tracking_link }}" style="width: 100%;" class="form-control" placeholder="https://tracking-service.com/...">
                </div>

                <button type="submit" class="btn btn-primary" style="width: 100%;">Update Order</button>
            </form>
        </div>

        <div class="card" style="padding: 1.5rem; background: #f8fafc;">
            <p style="margin-bottom: 0.5rem;"><strong>Payment Method:</strong> {{ strtoupper($order->payment_method) }}</p>
            <p style="margin: 0;"><strong>Placed On:</strong> {{ $order->created_at->format('M d, Y H:i') }}</p>
        </div>
    </div>
</div>
@endsection