@extends('layouts.admin')

@section('title', 'Manage Pests')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Pests</h2>
        <a href="{{ route('admin.pests.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Pest
        </a>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Slug</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($pests as $pest)
                <tr>
                    <td>
                        @if($pest->image)
                        <img src="/{{ $pest->image->path }}" style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px;">
                        @else
                        <div style="width: 50px; height: 50px; background: #f1f1f1; border-radius: 8px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        @endif
                    </td>
                    <td style="font-weight: 600;">{{ $pest->title }}</td>
                    <td>{{ $pest->category->name ?? 'N/A' }}</td>
                    <td>{{ $pest->slug }}</td>
                    <td>
                        <div style="display: flex; gap: 8px;">
                            <a href="{{ route('admin.pests.edit', $pest->id) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.pests.destroy', $pest->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete pest?')">
                                @csrf @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="padding: 2rem; text-align: center; color: #666;">No pests found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $pests->links() }}
    </div>
</div>
@endsection
