@extends('layouts.admin')

@section('title', 'Manage Products')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Products</h2>
        <a href="{{ route('admin.products.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Product
        </a>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; margin-top: 1rem;">
            <thead>
                <tr style="text-align: left; border-bottom: 2px solid #f1f1f1;">
                    <th style="padding: 1rem;">Thumb</th>
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Category</th>
                    <th style="padding: 1rem;">Price</th>
                    <th style="padding: 1rem;">Stock</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($products as $product)
                <tr style="border-bottom: 1px solid #f1f1f1;">
                    <td style="padding: 1rem;">
                        @if($product->thumbnail)
                        <div style="width: 50px; height: 50px; position: relative; border-radius: 8px; overflow: hidden; background: #f1f1f1;">
                            <img src="{{ asset_encoded($product->thumbnail->path) }}" alt="" style="width: 100%; height: 100%; object-fit: cover;" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                            <span style="display:none; position:absolute; inset:0; align-items:center; justify-content:center; color:#94a3b8;"><i class="fas fa-image"></i></span>
                        </div>
                        @else
                        <div style="width: 50px; height: 50px; background: #f1f1f1; border-radius: 8px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        @endif
                    </td>
                    <td style="padding: 1rem; font-weight: 600;">{{ $product->title }}</td>
                    <td style="padding: 1rem;">{{ $product->category->name }}</td>
                    <td style="padding: 1rem;">
                        @if($product->discount_price)
                        <span style="text-decoration: line-through; color: #999; font-size: 0.8rem;">PKR {{ $product->price }}</span>
                        <span style="color: var(--primary-red); font-weight:600;">PKR {{ $product->discount_price }}</span>
                        @else
                        <span>PKR {{ $product->price }}</span>
                        @endif
                    </td>
                    <td style="padding: 1rem;">{{ $product->stock_quantity }}</td>
                    <td style="padding: 1rem;">
                        <span style="padding: 4px 10px; border-radius: 20px; font-size: 0.8rem; background: {{ $product->status == 'in_stock' ? '#d4edda; color: #155724;' : '#f8d7da; color: #721c24;' }}">
                            {{ str_replace('_', ' ', ucfirst($product->status)) }}
                        </span>
                    </td>
                    <td style="padding: 1rem;">
                        <a href="{{ route('admin.products.edit', $product->id) }}" class="action-btn btn-edit">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.products.destroy', $product->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete product?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" style="padding: 2rem; text-align: center; color: #666;">No products found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $products->links() }}
    </div>
</div>
@endsection