@extends('layouts.admin')

@section('title', 'Manage Product Reviews')

@section('content')
@if(session('success'))
<div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
    {{ session('success') }}
</div>
@endif

<div class="card">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <h2 style="font-size: 1.2rem;">Product Reviews</h2>
        <form action="{{ route('admin.reviews.index') }}" method="GET" style="display: flex; gap: 10px;">
            <select name="product_id" onchange="this.form.submit()" style="padding: 0.5rem; border-radius: 6px; border: 1px solid #ddd;">
                <option value="">All Products</option>
                @foreach($products as $product)
                <option value="{{ $product->id }}" {{ request('product_id') == $product->id ? 'selected' : '' }}>
                    {{ $product->title }}
                </option>
                @endforeach
            </select>
        </form>
    </div>
    
    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; margin-top: 1rem;">
            <thead>
                <tr style="background: #f8fafc; text-align: left;">
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Product</th>
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Reviewer</th>
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Rating</th>
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Comment</th>
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Date</th>
                    <th style="padding: 1rem; border-bottom: 2px solid #edf2f7;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($reviews as $review)
                <tr>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        {{ $review->product->title ?? 'N/A' }}
                        <br>
                        <small style="color: #718096;">Avg: {{ $review->product->average_rating ?? 0 }} ★</small>
                    </td>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        <strong>{{ $review->name }}</strong><br>
                        <small>{{ $review->email }}</small>
                    </td>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        <span style="color: #f6ad55;">
                            @for($i = 1; $i <= 5; $i++)
                                <i class="{{ $i <= $review->rating ? 'fas' : 'far' }} fa-star"></i>
                            @endfor
                        </span>
                        ({{ $review->rating }})
                    </td>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        <div style="max-width: 300px; font-size: 0.9rem;">
                            {{ $review->comment }}
                        </div>
                    </td>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        {{ $review->created_at ? $review->created_at->format('M d, Y') : 'N/A' }}
                    </td>
                    <td style="padding: 1rem; border-bottom: 1px solid #edf2f7;">
                        <form action="{{ route('admin.reviews.delete', $review->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this review?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-delete" style="background: #e53e3e; color: white; border: none; padding: 0.5rem 0.75rem; border-radius: 4px; cursor: pointer;">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" style="padding: 2rem; text-align: center; color: #718096;">No reviews found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    
    <div style="padding: 1rem;">
        {{ $reviews->links() }}
    </div>
</div>
@endsection
