@extends('layouts.admin')

@section('title', 'Social Media')
@section('page_title', 'Social Links')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Social Media Links</h2>
        <button class="btn btn-primary" onclick="openModal('addSocialModal')">
            <i class="fas fa-plus"></i> Add Link
        </button>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>URL</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($socials as $social)
                <tr>
                    <td style="width: 60px; text-align: center;">
                        <i class="{{ $social->icon }} fa-lg"></i>
                    </td>
                    <td style="font-weight: 600;">{{ $social->name }}</td>
                    <td><a href="{{ $social->url }}" target="_blank" style="color: #3182ce;">{{ $social->url }}</a></td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <button class="action-btn btn-edit" onclick="editSocial({{ $social }})">
                                <i class="fas fa-edit"></i>
                            </button>
                            <form action="{{ route('admin.social-media.destroy', $social) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" style="text-align: center; padding: 3rem;">No social media links found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<!-- Add Modal -->
<div class="modal" id="addSocialModal">
    <div class="modal-content">
        <h3 style="margin-bottom: 1.5rem;">Add Social Link</h3>
        <form action="{{ route('admin.social-media.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label>Name (e.g. Facebook)</label>
                <input type="text" name="name" class="form-control" required>
            </div>
            <div class="form-group">
                <label>URL</label>
                <input type="url" name="url" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Icon (FontAwesome class)</label>
                <input type="text" name="icon" class="form-control" placeholder="fab fa-facebook">
            </div>
            <div style="display: flex; gap: 10px; justify-content: flex-end; margin-top: 2rem;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('addSocialModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save Link</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal" id="editSocialModal">
    <div class="modal-content">
        <h3 style="margin-bottom: 1.5rem;">Edit Social Link</h3>
        <form id="editSocialForm" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" id="edit_name" class="form-control" required>
            </div>
            <div class="form-group">
                <label>URL</label>
                <input type="url" name="url" id="edit_url" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Icon</label>
                <input type="text" name="icon" id="edit_icon" class="form-control">
            </div>
            <div style="display: flex; gap: 10px; justify-content: flex-end; margin-top: 2rem;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editSocialModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Update Link</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function editSocial(social) {
        document.getElementById('edit_name').value = social.name;
        document.getElementById('edit_url').value = social.url;
        document.getElementById('edit_icon').value = social.icon;
        document.getElementById('editSocialForm').action = '/admin/social-media/' + social.id;
        openModal('editSocialModal');
    }
</script>
@endsection
