@extends('layouts.admin')

@section('title', 'Edit Testimonial')
@section('page_title', 'Update Testimonial')

@section('content')
<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header">
        <h2>Edit Testimonial</h2>
    </div>
    <form action="{{ route('admin.testimonials.update', $testimonial) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Client Image</label>
                    <div style="margin-bottom: 10px;">
                        <img id="imagePreview" src="{{ $testimonial->imageFile ? asset($testimonial->imageFile->path) : 'https://ui-avatars.com/api/?name='.$testimonial->client_name }}" style="width: 150px; height: 150px; border-radius: 50%; border: 1px solid #ddd; object-fit: cover;">
                    </div>
                    <input type="hidden" name="client_image" id="imageInput" value="{{ $testimonial->client_image }}">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('imageInput', 'imagePreview')">
                        <i class="fas fa-image"></i> Change Image
                    </button>
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label>Client Name</label>
                    <input type="text" name="client_name" class="form-control" value="{{ old('client_name', $testimonial->client_name) }}" required>
                </div>
                <div class="form-group">
                    <label>Designation</label>
                    <input type="text" name="designation" class="form-control" value="{{ old('designation', $testimonial->designation) }}">
                </div>
            </div>
        </div>

        <div class="form-group">
            <label>Rating (1-5 stars)</label>
            <select name="rating" class="form-control" required>
                @for($i=5; $i>=1; $i--)
                <option value="{{ $i }}" {{ old('rating', $testimonial->rating) == $i ? 'selected' : '' }}>{{ $i }} Stars</option>
                @endfor
            </select>
        </div>

        <div class="form-group">
            <label>What Client Says</label>
            <textarea name="message" class="form-control" rows="5" required>{{ old('message', $testimonial->message) }}</textarea>
        </div>

        <div style="margin-top: 2rem; display: flex; gap: 10px; justify-content: flex-end;">
            <a href="{{ route('admin.testimonials.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Update Testimonial
            </button>
        </div>
    </form>
</div>
@endsection

@section('styles')
<style>
    .row {
        display: flex;
        flex-wrap: wrap;
        margin-right: -15px;
        margin-left: -15px;
    }

    .col-md-4 {
        flex: 0 0 33.333333%;
        max-width: 33.333333%;
        padding: 0 15px;
    }

    .col-md-8 {
        flex: 0 0 66.666667%;
        max-width: 66.666667%;
        padding: 0 15px;
    }

    .form-control {
        width: 100%;
        padding: 0.8rem 1rem;
        border: 2px solid #edf2f7;
        border-radius: 10px;
        font-size: 1rem;
    }
</style>
@endsection