<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\Api\CheckoutController;
use App\Http\Controllers\Api\ServiceApiController;
use App\Http\Controllers\Api\NavbarController;

Route::get('/navbar', [NavbarController::class, 'index']);
Route::get('/categories', [CategoryController::class, 'index']);
Route::get('/categories/{slug}/products', [CategoryController::class, 'products']);

Route::get('/products', [ProductController::class, 'index']);
Route::get('/products/{slug}', [ProductController::class, 'show']);
Route::post('/products/{productId}/reviews', [\App\Http\Controllers\Api\ReviewController::class, 'store']);

Route::get('/blogs', [BlogController::class, 'index']);
Route::get('/blogs/{slug}', [BlogController::class, 'show']);

Route::post('/checkout', [CheckoutController::class, 'process']);

// New API Routes
Route::get('/about-us', [\App\Http\Controllers\Api\PageController::class, 'aboutUs']);
Route::get('/distributors', [\App\Http\Controllers\Api\DistributorController::class, 'index']);
Route::get('/distributors/{slug}', [\App\Http\Controllers\Api\DistributorController::class, 'show']);
Route::get('/registrations', [\App\Http\Controllers\Api\RegistrationController::class, 'index']);
Route::get('/registrations/{slug}', [\App\Http\Controllers\Api\RegistrationController::class, 'show']);
Route::get('/why-choose-us', [\App\Http\Controllers\Api\WhyChooseUsController::class, 'index']);
Route::get('/testimonials', [\App\Http\Controllers\Api\TestimonialController::class, 'index']);
Route::get('/footer', [\App\Http\Controllers\Api\PageController::class, 'footer']);
Route::get('/contact-info', [\App\Http\Controllers\Api\ContactController::class, 'info']);
Route::post('/contact/messages', [\App\Http\Controllers\Api\ContactController::class, 'store']);
Route::get('/home', [\App\Http\Controllers\Api\HomeCmsController::class, 'getHome']);
Route::get('/services', [ServiceApiController::class, 'index']);
Route::get('/service-categories-simple', [ServiceApiController::class, 'getCategoriesSimple']);
Route::get('/services/{slug}', [ServiceApiController::class, 'getService']);
Route::get('/service-categories/{slug}', [ServiceApiController::class, 'getCategory']);
Route::get('/service-areas', [ServiceApiController::class, 'getAreas']);
Route::get('/service-areas/{slug}', [ServiceApiController::class, 'getArea']);
Route::get('/top-services', [ServiceApiController::class, 'getTopServices']);
Route::get('/faqs', [\App\Http\Controllers\Api\FaqApiController::class, 'index']);
Route::get('/page-seo/{page_name}', function ($page_name) {
    return \App\Models\PageSeo::where('page_name', $page_name)->first();
});
Route::get('/pest-library', [\App\Http\Controllers\Api\PestApiController::class, 'categories']);
Route::get('/pests', [\App\Http\Controllers\Api\PestApiController::class, 'pests']);
Route::get('/pests/{slug}', [\App\Http\Controllers\Api\PestApiController::class, 'pestDetail']);
