<?php $__env->startSection('title', 'Service Areas'); ?>
<?php $__env->startSection('page_title', 'Manage Service Areas'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h2>Service Areas List</h2>
        <a href="<?php echo e(route('admin.service-areas.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Area
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Short Description</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td style="width: 60px; text-align: center;">
                        <i class="<?php echo e($area->icon ?: 'fas fa-map-marker-alt'); ?> fa-lg" style="color: var(--primary-red);"></i>
                    </td>
                    <td style="font-weight: 700;"><?php echo e($area->name); ?></td>
                    <td><code><?php echo e($area->slug); ?></code></td>
                    <td style="font-size: 0.85rem; color: #64748b;"><?php echo e(Str::limit($area->short_description, 50)); ?></td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="<?php echo e(route('admin.service-areas.edit', $area)); ?>" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.service-areas.destroy', $area)); ?>" method="POST" onsubmit="return confirm('Are you sure?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" style="text-align: center; padding: 3rem; color: #94a3b8;">
                        No service areas found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/service-areas/index.blade.php ENDPATH**/ ?>